# WhatsApp Server - Windows Installation Guide

## Quick Start (3 Steps)

### Step 1: Install Node.js
Before running the WhatsApp server, you need Node.js installed on your computer.

1. Visit https://nodejs.org/
2. Download the **LTS version** (recommended)
3. Run the installer and follow the prompts
4. **IMPORTANT**: Restart your computer after installation

### Step 2: Install Dependencies
Double-click one of these files to install:
- **DOUBLE-CLICK-ME.bat** (Easiest - does everything automatically)
- **SETUP.bat** (Same as above)
- **install.bat** (Basic installation)

Wait 2-5 minutes for the installation to complete. The window will stay open and show you the progress.

### Step 3: Start the Server
After installation completes:
1. Double-click **START.bat** or **run.bat**
2. Wait for the QR code to appear in the window
3. Scan the QR code with your WhatsApp mobile app
4. Start sending messages!

---

## Important Notes

### ✅ Windows Stay Open
All batch files now keep the window open automatically. You can read any errors or messages without the window closing.

### ✅ Works from Any Location
You can run these files from any folder on your computer. They will automatically find and use the correct directory.

### ✅ Error Handling
If something goes wrong:
- The window will stay open
- You'll see a clear error message
- Follow the instructions shown in the window

---

## File Descriptions

| File | Purpose |
|------|---------|
| **DOUBLE-CLICK-ME.bat** | Main entry point - runs automatic setup and starts server |
| **SETUP.bat** | Automatic installation with Node.js detection |
| **install.bat** | Basic dependency installation |
| **START.bat** | Checks setup and starts the server |
| **run.bat** | Runs the WhatsApp server |

---

## Troubleshooting

### Problem: Window Closes Immediately
**Fixed!** All batch files now keep the window open. If you still see this, download the latest version.

### Problem: "Node.js is not installed"
1. Install Node.js from https://nodejs.org/
2. Choose the LTS version
3. **Restart your computer**
4. Run the batch file again

### Problem: "Dependencies not installed"
1. Run **install.bat** or **SETUP.bat**
2. Wait for it to complete
3. Then run **START.bat**

### Problem: Installation Fails
1. Check your internet connection
2. Right-click the batch file and select "Run as Administrator"
3. Try running: `npm cache clean --force` in Command Prompt
4. Run the installer again

### Problem: Server Won't Start
1. Make sure Node.js is installed: Open Command Prompt and type `node --version`
2. Make sure dependencies are installed: Check if `node_modules` folder exists
3. Run **install.bat** if the folder doesn't exist

---

## Manual Installation (Advanced)

If the automatic installers don't work:

1. Open Command Prompt as Administrator
2. Navigate to the whatsapp-server folder:
   ```
   cd path\to\whatsapp-server
   ```
3. Run:
   ```
   npm install
   ```
4. After installation completes, run:
   ```
   node server.js
   ```

---

## System Requirements

- **Operating System**: Windows 7, 8, 10, or 11
- **Node.js**: Version 14 or higher (LTS recommended)
- **RAM**: 2GB minimum, 4GB recommended
- **Internet**: Required for installation and WhatsApp connection

---

## Getting Help

If you encounter issues:
1. Read the error message carefully
2. Check the troubleshooting section above
3. Make sure Node.js is installed and updated
4. Try running as Administrator
5. Check your internet connection

---

## Security Notes

- Never share your `.wwebjs_auth` folder - it contains your WhatsApp session
- The server runs locally on port 3000
- Only accessible from your computer unless you configure otherwise
- No data is sent to external servers (except WhatsApp)

---

## What Gets Installed?

The installer will:
1. Check for Node.js
2. Install these packages:
   - whatsapp-web.js (WhatsApp Web client)
   - express (Web server)
   - cors (Cross-origin support)
   - multer (File upload handling)
   - qrcode-terminal (QR code display)
3. Create required folders:
   - `uploads/` (for file uploads)
   - `.wwebjs_auth/` (for WhatsApp session)
4. Set up everything automatically

Total installation size: Approximately 200-300MB

---

## Next Steps After Installation

1. **Start the server**: Run START.bat
2. **Scan QR code**: Use WhatsApp mobile app
3. **Test connection**: Open http://localhost:3000/health in your browser
4. **Use the interface**: Go to your main app and select "Self-Hosted" option

---

*Last Updated: 2025-10-23*
