# WhatsApp Self-Hosted Server - Download & Setup

## 📦 Package Contents

This folder contains everything you need to run your own WhatsApp server:

```
whatsapp-server/
├── package.json          - Node.js dependencies
├── server.js             - Main server application
├── install.bat          - Windows installation script
├── run.bat              - Windows run script
├── install.sh           - Mac/Linux installation script
├── run.sh               - Mac/Linux run script
└── README.txt           - Detailed instructions
```

## 🚀 Quick Start

### For Windows Users:
1. Download this entire folder
2. Double-click `install.bat` to install dependencies
3. Double-click `run.bat` to start the server
4. Scan QR code with WhatsApp
5. Go to website and connect

### For Mac/Linux Users:
1. Download this entire folder
2. Open Terminal in this directory
3. Run: `chmod +x install.sh run.sh`
4. Run: `./install.sh` to install dependencies
5. Run: `./run.sh` to start the server
6. Scan QR code with WhatsApp
7. Go to website and connect

## 📋 Requirements

- **Node.js 16 or higher** (Download from https://nodejs.org/)
- Active WhatsApp account
- Internet connection
- ~500MB free disk space

## 🔗 Download Options

### Option 1: ZIP Download (Recommended)
Download the complete ZIP package from:
https://tinytoolpro.com/whatsapp-bulk-sender/whatsapp-server.zip

### Option 2: Manual File Creation
Create a folder named "whatsapp-server" and copy all files from this directory into it.

### Option 3: Git Clone (For Developers)
```bash
git clone https://github.com/tinytoolpro/whatsapp-server.git
cd whatsapp-server
```

## 🌐 Website Integration

After starting the server:
1. Visit: https://tinytoolpro.com/whatsapp-bulk-sender/app.php
2. Click on "Self-Hosted" tab
3. Click "Connect" button
4. Start sending messages!

## 📚 Complete Documentation

For detailed setup instructions, troubleshooting, and FAQ:
https://tinytoolpro.com/whatsapp-bulk-sender/self-hosted-guide.html

## 💡 Features

- ✅ 100% Free - No API costs
- ✅ Complete Privacy - Data stays on your computer
- ✅ Unlimited Messages - No rate limits
- ✅ Your Own WhatsApp - Use your personal/business number
- ✅ Easy Setup - Automated installation scripts
- ✅ Cross-Platform - Works on Windows, Mac, Linux

## 🆘 Support

Need help? Visit:
- Setup Guide: https://tinytoolpro.com/whatsapp-bulk-sender/self-hosted-guide.html
- Contact: https://tinytoolpro.com/contact/
- Email: support@tinytoolpro.com

## ⚠️ Important Notes

1. Keep the terminal/command prompt window open while using
2. Don't log out from WhatsApp on your phone while connected
3. Follow WhatsApp's terms of service - no spamming
4. The `.wwebjs_auth` folder contains your session - keep it secure

## 🔄 Updates

This is version 1.0.0. Check for updates at:
https://tinytoolpro.com/whatsapp-bulk-sender/

---

© 2025 TinyToolPro - WhatsApp Bulk Sender Pro
