# FIX: Server Stuck at "Initializing WhatsApp Web.js client..."

## Quick Diagnosis

Run this command in the whatsapp-server folder:
```bash
node diagnose.js
```

This will check your system and tell you what's wrong.

---

## Most Likely Cause: Chrome Not Available

The server needs Chrome/Chromium to work. If you don't have it installed:

### Windows
1. Download and install Chrome: https://www.google.com/chrome/
2. Restart your terminal
3. Try again: `node server.js`

### Linux
```bash
sudo apt-get update
sudo apt-get install -y chromium-browser
```

### Mac
1. Download and install Chrome: https://www.google.com/chrome/
2. Try again: `node server.js`

---

## Solution #1: Force Install Puppeteer

Puppeteer includes Chrome. Run this:
```bash
npm install puppeteer --force
```

Then try: `node server.js`

---

## Solution #2: Delete Old Session

Sometimes old session data causes issues:

**Windows:**
```bash
rmdir /s .wwebjs_auth
node server.js
```

**Linux/Mac:**
```bash
rm -rf .wwebjs_auth
node server.js
```

---

## Solution #3: Use Working Server

If `server.js` doesn't work, try the simplified version:
```bash
node working-small-server.js
```

This opens Chrome in visible mode so you can see what's happening.

**Note:** You must have Chrome installed for this to work. It will try to open at:
- Windows: `C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe`
- Mac: `/Applications/Google Chrome.app/Contents/MacOS/Google Chrome`
- Linux: Will use system Chrome

---

## Solution #4: Check Browser Path

If working-small-server.js says "Chrome not found", you need to:

1. Find where Chrome is installed on your computer
2. Edit `working-small-server.js`
3. Change the `executablePath` line to your Chrome location

Example for different paths:
```javascript
// Windows - different install location
executablePath: 'C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe',

// Linux - using chromium
executablePath: '/usr/bin/chromium-browser',

// Mac
executablePath: '/Applications/Google Chrome.app/Contents/MacOS/Google Chrome',
```

---

## Solution #5: View QR Code in Browser

Even if terminal doesn't show QR code, you can view it in browser:

1. Start server: `node server.js`
2. Wait 1-2 minutes
3. Open browser: `http://localhost:3000/qr`
4. You should see QR code there!

---

## Solution #6: Update Dependencies

Try updating to latest versions:
```bash
npm update
npm install whatsapp-web.js@latest
node server.js
```

---

## Web App Connection Issue

If server works but web app can't connect:

### Problem: "Cannot connect to server"

**Check #1: Is server running?**
```bash
# You should see this in terminal:
Server running on: http://localhost:3000
```

**Check #2: Test server health**

Open browser to: `http://localhost:3000/health`

Should show:
```json
{"status":"ok","message":"WhatsApp server is running"}
```

**Check #3: Same computer?**

The server MUST be running on the SAME computer where you open the web app.

If server is on Computer A but you access web from Computer B → Won't work!

**Check #4: Use IP instead of localhost**

If web app is on same computer but still can't connect:

1. Find your computer's IP address:
   - Windows: `ipconfig` (look for IPv4)
   - Mac/Linux: `ifconfig` (look for inet)

2. In web app Self-Hosted tab, change URL from:
   - `http://localhost:3000`
   - To: `http://YOUR_IP:3000` (example: `http://192.168.1.100:3000`)

3. Click "Connect to Local Server"

---

## Verify Everything Works

### Step 1: Start Server
```bash
cd whatsapp-server
node server.js
```

**Expected:**
```
============================================================
WhatsApp Web.js Self-Hosted Server
============================================================
Server running on: http://localhost:3000
```

### Step 2: Check Health (in browser)
Go to: `http://localhost:3000/health`

**Expected:**
```json
{"status":"ok","message":"WhatsApp server is running"}
```

### Step 3: View QR Code (in browser)
Go to: `http://localhost:3000/qr`

Wait 1-2 minutes if it says "Generating QR Code..."

**Expected:** Big QR code with instructions

### Step 4: Scan QR Code
1. Open WhatsApp on phone
2. Settings → Linked Devices → Link a Device
3. Scan the QR code
4. Wait for success message in terminal

**Expected in terminal:**
```
============================================================
SUCCESS! WhatsApp Client is ready!
============================================================
```

### Step 5: Connect from Web App
1. Go to: https://tinytoolpro.com/whatsapp-bulk-sender/app.php
2. Click "Self-Hosted" tab
3. Click "Connect to Local Server"

**Expected:** Green message "Connected successfully!"

---

## Still Not Working?

1. Run diagnostic: `node diagnose.js`
2. Read full guide: `TROUBLESHOOTING.md`
3. Check the error message carefully
4. Make sure:
   - Chrome is installed
   - Port 3000 is free
   - Internet is working
   - No firewall blocking

---

## Quick Test Commands

```bash
# Check if Node.js is installed
node --version

# Should be 16 or higher

# Check if dependencies are installed
npm list --depth=0

# Should show express, whatsapp-web.js, etc.

# Check if port 3000 is free
# Windows:
netstat -ano | findstr :3000

# Linux/Mac:
lsof -i :3000

# Should show nothing if port is free

# Test server starts
node server.js

# Should see "Server running on: http://localhost:3000"
```

---

## Common Error Solutions

| Error | Solution |
|-------|----------|
| Could not find Chrome | Install Chrome from google.com/chrome |
| EADDRINUSE | Port 3000 busy, change PORT in server.js |
| Cannot find module | Run `npm install` |
| TimeoutError | Delete .wwebjs_auth and try again |
| QR code not showing | Use browser: http://localhost:3000/qr |
| Web app can't connect | Make sure server is running on same computer |

---

## Contact Information

If you're still stuck after trying all these solutions, make sure to:

1. Note the exact error message from terminal
2. Check which step fails (from "Verify Everything Works" section)
3. Include results from `node diagnose.js`
4. Mention your operating system and Node.js version
