@echo off
SETLOCAL ENABLEEXTENSIONS
SETLOCAL ENABLEDELAYEDEXPANSION

:: Keep window open
if "%1" neq "KEEPOPEN" (
    cmd /k "%~f0" KEEPOPEN
    exit /b
)

:: Change to script directory
cd /d "%~dp0"

title WhatsApp Server - One-Click Setup and Run

color 0E

echo.
echo ============================================================
echo         WhatsApp Server - ONE-CLICK INSTALLER
echo ============================================================
echo.
echo This script will automatically:
echo   - Check if Node.js is installed
echo   - Install all required dependencies
echo   - Start the WhatsApp server
echo.
echo Please wait...
echo.
echo ============================================================
echo.

:: Step 0: Auto-clean session for fresh start
echo [Step 0/4] Checking session status...
if exist ".wwebjs_auth" (
    echo [INFO] Found existing session folder.
    echo [INFO] Deleting old session for fresh start...
    rmdir /s /q ".wwebjs_auth" 2>nul
    echo [OK] Old session deleted! Will create new session.
) else (
    echo [OK] No existing session found. Will create fresh session.
)
echo.

:: Step 1: Check Node.js
echo [Step 1/4] Checking Node.js...
where node >nul 2>nul
if %ERRORLEVEL% NEQ 0 (
    echo [ERROR] Node.js is NOT installed!
    echo.
    echo Please install Node.js first:
    echo 1. Visit: https://nodejs.org/
    echo 2. Download the LTS version
    echo 3. Install it
    echo 4. RESTART your computer
    echo 5. Run this script again
    echo.
    set /p OPEN_BROWSER="Press Y to open Node.js website, or N to exit: "
    if /i "!OPEN_BROWSER!"=="Y" (
        start https://nodejs.org/
    )
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

for /f "tokens=*" %%i in ('node --version') do set NODE_VERSION=%%i
echo [OK] Node.js %NODE_VERSION% found!
echo.

:: Step 2: Check package.json
echo [Step 2/5] Checking project files...
if not exist "package.json" (
    echo [ERROR] package.json not found!
    echo Make sure you're running this from the correct folder.
    echo Current folder: %CD%
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)
echo [OK] Project files found!
echo.

:: Step 3: Install dependencies (only if needed)
echo [Step 3/5] Checking dependencies...
if not exist "node_modules\" (
    echo Dependencies not installed. Installing now...
    echo This will take 2-5 minutes. Please wait...
    echo.

    :: Clean install
    if exist "package-lock.json" del /f /q "package-lock.json" 2>nul

    :: Install
    call npm install --no-audit --no-fund

    if %ERRORLEVEL% EQU 0 (
        echo.
        echo [OK] Dependencies installed successfully!

        :: Verify installation
        if exist "node_modules\whatsapp-web.js\" (
            echo [OK] whatsapp-web.js installed
        )
        if exist "node_modules\express\" (
            echo [OK] express installed
        )
        echo.
    ) else (
        echo.
        echo [WARNING] Standard installation failed. Trying alternative method...
        call npm install --legacy-peer-deps --no-audit --no-fund

        if %ERRORLEVEL% EQU 0 (
            echo [OK] Dependencies installed with legacy mode!
            echo.
        ) else (
            echo [ERROR] Installation failed!
            echo.
            echo Please try:
            echo 1. Check internet connection
            echo 2. Run as Administrator
            echo 3. Manually run: npm install
            echo.
            echo Press any key to exit...
            pause >nul
            exit /b 1
        )
    )
) else (
    echo [OK] Dependencies already installed!
    echo.
)

:: Step 4: Create directories
echo [Step 4/5] Creating required directories...
if not exist "uploads\" mkdir "uploads" 2>nul
if not exist ".wwebjs_auth\" mkdir ".wwebjs_auth" 2>nul
echo [OK] Directories ready!
echo.

:: Step 5: Final preparation
echo [Step 5/5] Preparing to start server...
if exist ".wwebjs_auth\session" (
    echo [INFO] Will use existing WhatsApp session.
) else (
    echo [INFO] Will create new WhatsApp session.
)
echo [OK] Ready to start!
echo.

:: Success message
echo ============================================================
echo                    SETUP COMPLETE!
echo ============================================================
echo.
echo Everything is ready! Starting the server now...
echo.
echo IMPORTANT INSTRUCTIONS:
echo  1. Wait for QR code to appear below
echo  2. Open WhatsApp on your phone
echo  3. Go to: Settings ^> Linked Devices
echo  4. Tap: Link a Device
echo  5. Scan the QR code that will appear
echo.
echo After scanning:
echo  - Go to your web interface
echo  - Select "Self-Hosted"
echo  - Click "Connect"
echo  - Start sending messages!
echo.
echo Server URL: http://localhost:3000
echo.
echo Press Ctrl+C to stop the server anytime
echo.
echo ============================================================
echo.

timeout /t 3 /nobreak >nul

:: Give option to diagnose first (auto-skip after 3 seconds)
echo.
echo Do you want to run diagnostics first? (Y/N)
echo Auto-starting server in 3 seconds...
echo.

choice /C YN /T 3 /D N /M "Run diagnostics? (Y/N)"
if %ERRORLEVEL% EQU 1 (
    echo.
    echo Running diagnostics...
    echo.
    node diagnose.js
    echo.
    echo Press any key to continue starting the server...
    pause >nul
    echo.
) else (
    echo.
    echo Skipping diagnostics...
    echo.
)

:: Start the server
echo Starting server...
echo.
echo IMPORTANT: When you close this window, the server will stop automatically.
echo.
echo If stuck at "Initializing WhatsApp Web.js client..." for more than 2 minutes:
echo  1. Open browser to: http://localhost:3000/qr
echo  2. You should see the QR code there!
echo  3. If blank, wait 30 seconds and refresh the page
echo.
echo Alternative: If QR code never appears, try:
echo  - Close this window and run again (fresh session)
echo  - See FIX-QR-ISSUE.md for solutions
echo.
echo ============================================================
echo.

:: Register cleanup on exit
call :SETUP_CLEANUP

:: Start server
node server.js

:: Cleanup after server stops
call :CLEANUP
goto :END

:SETUP_CLEANUP
:: This will be called when script exits
goto :EOF

:CLEANUP
echo.
echo ============================================================
echo Cleaning up...
echo ============================================================
echo.

:: Kill all node processes
echo [INFO] Stopping Node.js processes...
taskkill /F /IM node.exe 2>nul
if %ERRORLEVEL% EQU 0 (
    echo [OK] Node.js stopped.
) else (
    echo [INFO] No Node.js processes to stop.
)

:: Clean up Chrome processes from WhatsApp Web
echo [INFO] Stopping Chrome processes...
taskkill /F /IM chrome.exe /FI "WINDOWTITLE eq *WhatsApp*" 2>nul
taskkill /F /IM chrome.exe /FI "WINDOWTITLE eq *localhost:3000*" 2>nul

echo [OK] Cleanup complete.
echo.
goto :EOF

:END
echo ============================================================
echo Server has stopped.
echo ============================================================
echo.
echo To restart: Double-click this file again
echo Session will be cleaned on next run for fresh start.
echo.
echo Press any key to exit...
pause >nul
exit /b
