# WhatsApp Server - Quick Reference

## 🚀 Quick Start

### Windows
```batch
Double-click: INSTALL-AND-RUN.bat
```

### Mac/Linux
```bash
./INSTALL-AND-RUN.sh
```

## 📋 All Available Scripts

| Script | Platform | Purpose |
|--------|----------|---------|
| `INSTALL-AND-RUN.bat` | Windows | **One-click** installer and runner |
| `INSTALL-AND-RUN.sh` | Mac/Linux | **One-click** installer and runner |
| `DOUBLE-CLICK-ME.sh` | Mac/Linux | Quick launcher |
| `install.sh` | Mac/Linux | Manual installation only |
| `run.sh` | Mac/Linux | Manual run only |
| `SETUP.sh` | Mac/Linux | Full automatic setup |
| `START.sh` | Mac/Linux | Start with auto-install |

## 📖 Documentation Files

### In Root Folder
| File | Description |
|------|-------------|
| `README.md` | **Start here** - Main comprehensive guide |
| `README.txt` | Simple text guide |
| `QUICK-START.md` | Quick start instructions |
| `TROUBLESHOOTING.md` | Problem solving guide |
| `WINDOWS-GUIDE.md` | Windows-specific guide |
| `CHANGES.md` | Recent changes and updates |
| `QUICK-REFERENCE.md` | This file |

### In docs/ Folder (22 files)
| File | Description |
|------|-------------|
| `docs/README.md` | **Documentation index** |
| `docs/START-HERE-READ-FIRST.txt` | Absolute beginner's guide |
| `docs/QUICK-ANSWERS.txt` | Fast Q&A |
| `docs/FIX-QR-ISSUE.md` | QR code troubleshooting |
| `docs/SESSION-FIX.md` | Connection issues |
| `docs/VISUAL-GUIDE.txt` | Step-by-step visual guide |
| ...and 16 more files | See `docs/README.md` for complete list |

## 🌐 Server Endpoints

| URL | Purpose |
|-----|---------|
| `http://localhost:3000` | Main server |
| `http://localhost:3000/qr` | View QR code in browser |
| `http://localhost:3000/health` | Health check |
| `http://localhost:3000/api/status` | Server status (JSON) |
| `http://localhost:3000/api/qr` | QR code data (API) |

## 🔧 Common Commands

### Check Installation
```bash
node --version
npm --version
```

### Manual Installation
```bash
npm install
```

### Start Server Manually
```bash
node server.js
```

### Run Diagnostics
```bash
node diagnose.js
```

### Clean Session
```bash
rm -rf .wwebjs_auth    # Mac/Linux
rmdir /s .wwebjs_auth  # Windows
```

## 🛠️ Troubleshooting Quick Fixes

### QR Code Not Showing
→ Open browser: `http://localhost:3000/qr`

### WhatsApp Won't Connect
→ Delete `.wwebjs_auth` folder and restart

### Port 3000 In Use
→ Edit `server.js`, change `PORT = 3000` to another port

### Installation Fails
→ Run: `npm cache clean --force` then try again

### Node.js Not Found (Windows)
→ Install from https://nodejs.org/ and **restart computer**

### Node.js Not Found (Mac/Linux)
→ Ubuntu: `sudo apt-get install nodejs npm`
→ Mac: `brew install node`

## 📁 Important Folders

| Folder | Purpose | Auto-created |
|--------|---------|--------------|
| `node_modules/` | Dependencies | ✅ Yes |
| `.wwebjs_auth/` | WhatsApp session | ✅ Yes |
| `uploads/` | File uploads | ✅ Yes |
| `docs/` | Documentation | ❌ No (included) |

## 🔒 Security Tips

- Server runs on localhost only (safe by default)
- Keep `.wwebjs_auth` folder private
- Never share session data
- Session auto-cleans on each run

## 📊 File Structure

```
whatsapp-server/
├── INSTALL-AND-RUN.bat      # Windows installer
├── INSTALL-AND-RUN.sh       # Mac/Linux installer
├── server.js                # Main server
├── package.json             # Dependencies
├── README.md                # Main docs
└── docs/                    # All guides
```

## 💡 Pro Tips

1. **First time?** Read `README.md` first
2. **Problems?** Check `TROUBLESHOOTING.md`
3. **QR issues?** See `docs/FIX-QR-ISSUE.md`
4. **Quick help?** See `docs/QUICK-ANSWERS.txt`
5. **Visual learner?** See `docs/VISUAL-GUIDE.txt`

## 🎯 What Each File Does

### Installation Scripts
- `INSTALL-AND-RUN.bat/sh` → Everything in one click
- `install.sh` → Just install dependencies
- `run.sh` → Just run server (requires install first)
- `SETUP.sh` → Full setup with Node.js check
- `START.sh` → Smart starter (installs if needed)

### Server Files
- `server.js` → Main WhatsApp server
- `diagnose.js` → Diagnostic tool
- `package.json` → Dependency list

### Documentation
- `README.md` → Main entry point
- `QUICK-START.md` → Fast setup guide
- `TROUBLESHOOTING.md` → Problem solver
- `docs/README.md` → Documentation index

## ⚡ Super Quick Start (TL;DR)

**Windows:**
```
1. Double-click INSTALL-AND-RUN.bat
2. Wait for QR code
3. Scan with WhatsApp
4. Done!
```

**Mac/Linux:**
```
1. ./INSTALL-AND-RUN.sh
2. Wait for QR code
3. Scan with WhatsApp
4. Done!
```

## 🆘 Get Help

1. **Quick answers:** `docs/QUICK-ANSWERS.txt`
2. **QR problems:** `docs/FIX-QR-ISSUE.md`
3. **Can't install:** `TROUBLESHOOTING.md`
4. **Need basics:** `docs/START-HERE-READ-FIRST.txt`
5. **All docs:** `docs/README.md`

## 📞 Support Resources

- Main README: `README.md`
- Documentation Index: `docs/README.md`
- Troubleshooting: `TROUBLESHOOTING.md`
- Diagnostics: `node diagnose.js`
- Server logs: Check terminal output

---

**Remember:** Most issues are solved by deleting `.wwebjs_auth` and running the installer again!

For detailed help, see `README.md` or `docs/README.md`
