# WhatsApp Server - Quick Start Guide

## 🚀 Installation

### Windows
1. Double-click `install.bat`
2. Wait for installation to complete (2-5 minutes)
3. Double-click `run.bat` to start the server

### Linux/Mac
1. Open terminal in this directory
2. Run: `chmod +x install.sh && ./install.sh`
3. Run: `./run.sh` to start the server

---

## 📋 Requirements

- **Node.js** version 14 or higher ([Download here](https://nodejs.org/))
- Internet connection for initial setup
- WhatsApp account and mobile phone

---

## 🔧 Troubleshooting

### Issue: "Node.js is not installed"
**Solution:** Download and install Node.js from https://nodejs.org/

### Issue: Installation closes immediately
**Solution:**
- Right-click `install.bat` and select "Run as Administrator" (Windows)
- Or run from Command Prompt/Terminal

### Issue: Dependencies not installing
**Solutions:**
1. Check your internet connection
2. Clear npm cache: `npm cache clean --force`
3. Delete `node_modules` folder and run installer again
4. Update npm: `npm install -g npm@latest`

### Issue: Port 3000 already in use
**Solution:**
1. Close other applications using port 3000
2. Or edit `server.js` and change `PORT = 3000` to another port

### Issue: WhatsApp won't connect
**Solutions:**
1. Make sure you scanned the QR code correctly
2. Check your phone's internet connection
3. Restart the server and try again
4. Delete `.wwebjs_auth` folder and reconnect

---

## 📁 Files Structure

```
whatsapp-server/
├── install.bat         # Windows installer
├── install.sh          # Linux/Mac installer
├── run.bat             # Windows runner
├── run.sh              # Linux/Mac runner
├── server.js           # Main server code
├── package.json        # Dependencies list
├── node_modules/       # Installed packages (created after install)
├── uploads/            # Temporary file uploads (created automatically)
└── .wwebjs_auth/       # WhatsApp session data (created on first connection)
```

---

## 🌐 Server Endpoints

Once running, access these URLs:

- **Health Check:** http://localhost:3000/health
- **Status:** http://localhost:3000/api/status
- **QR Code:** http://localhost:3000/api/qr
- **Connect:** POST http://localhost:3000/api/connect
- **Send Message:** POST http://localhost:3000/api/send-message
- **Send File:** POST http://localhost:3000/api/send-file

---

## 📞 Support

If you encounter issues:
1. Check this guide first
2. Verify Node.js is installed: `node --version`
3. Verify npm is installed: `npm --version`
4. Check server logs for error messages
5. Try reinstalling dependencies

---

## ⚡ Quick Commands

### Windows (Command Prompt)
```batch
# Install
install.bat

# Run server
run.bat

# Check Node.js version
node --version
```

### Linux/Mac (Terminal)
```bash
# Install
chmod +x install.sh && ./install.sh

# Run server
./run.sh

# Check Node.js version
node --version
```

---

## 🔒 Security Notes

- Server runs on **localhost** only by default (not accessible from other computers)
- WhatsApp session is stored in `.wwebjs_auth/` folder
- Keep this folder secure and private
- Don't share your session data with anyone

---

## 📝 License

MIT License - Free to use and modify

---

**Made with ❤️ for TinyToolPro**
