# WhatsApp Web.js Self-Hosted Server

A powerful, easy-to-use self-hosted WhatsApp messaging server built with Node.js and whatsapp-web.js. Send WhatsApp messages directly from your own server with a simple web interface.

## 🚀 Quick Start

### Windows Users (RECOMMENDED)

**One-Click Installation:**
```
Double-click: INSTALL-AND-RUN.bat
```

That's it! The script will:
- Check and install Node.js if needed
- Install all dependencies automatically
- Start the server
- Display the QR code for WhatsApp authentication

### Mac/Linux Users

**One-Click Installation:**
```bash
./INSTALL-AND-RUN.sh
```

Or use the convenient launcher:
```bash
./DOUBLE-CLICK-ME.sh
```

## 📋 Requirements

The installation scripts handle everything automatically. You only need:
- **Node.js** v14 or higher (auto-installed on first run)
- **npm** (comes with Node.js)
- **Internet connection** for dependency installation

## 🎯 Features

- ✅ **One-click setup** - No technical knowledge required
- ✅ **Self-hosted** - Full control over your data
- ✅ **Web-based QR code viewer** - View QR code in browser
- ✅ **Multiple QR code access methods** - Terminal, browser, or web app
- ✅ **Auto-session management** - Fresh session on each restart
- ✅ **File attachments** - Send images, documents, and media
- ✅ **Group messaging** - Send to groups and contacts
- ✅ **RESTful API** - Easy integration with other apps
- ✅ **Health monitoring** - Built-in diagnostics and health checks

## 📖 How to Use

### First Time Setup

1. **Run the installer**
   - Windows: Double-click `INSTALL-AND-RUN.bat`
   - Mac/Linux: Run `./INSTALL-AND-RUN.sh`

2. **Wait for QR code** (appears in 30-60 seconds)
   - Option A: Scan from terminal window
   - Option B: Open browser to `http://localhost:3000/qr`
   - Option C: Use web interface "Show QR Code" button

3. **Scan with WhatsApp**
   - Open WhatsApp on your phone
   - Go to: **Settings → Linked Devices**
   - Tap: **Link a Device**
   - Scan the QR code

4. **Start sending messages!**
   - Open your web interface
   - Select "Self-Hosted" option
   - Click "Connect"
   - Send messages instantly

### After First Setup

Simply run the same script again:
- Windows: `INSTALL-AND-RUN.bat`
- Mac/Linux: `./INSTALL-AND-RUN.sh`

The server will start immediately with all dependencies already installed.

## 🔧 Manual Installation (Alternative Method)

If you prefer manual control:

### Windows
```batch
1. Double-click SETUP.bat (one-time setup)
2. Wait for installation to complete
3. Double-click START.bat to run server
```

### Mac/Linux
```bash
chmod +x *.sh
./install.sh    # One-time setup
./run.sh        # Start server
```

## 🌐 Server Endpoints

Once running, access these URLs:

| Endpoint | Description |
|----------|-------------|
| `http://localhost:3000` | Main server |
| `http://localhost:3000/qr` | QR code viewer (web page) |
| `http://localhost:3000/health` | Health check |
| `http://localhost:3000/api/status` | Server status (JSON) |
| `http://localhost:3000/api/qr` | QR code data (API) |

## 📁 Project Structure

```
whatsapp-server/
├── server.js                  # Main server code
├── diagnose.js               # Diagnostic tool
├── package.json              # Dependencies
│
├── INSTALL-AND-RUN.bat       # Windows one-click installer
├── INSTALL-AND-RUN.sh        # Mac/Linux one-click installer
├── DOUBLE-CLICK-ME.sh        # Quick launcher for Mac/Linux
│
├── install.sh                # Manual installer (Mac/Linux)
├── run.sh                    # Manual runner (Mac/Linux)
├── SETUP.sh                  # Full auto-setup (Mac/Linux)
├── START.sh                  # Server starter
│
├── README.md                 # This file
├── QUICK-START.md            # Quick start guide
├── TROUBLESHOOTING.md        # Troubleshooting guide
├── WINDOWS-GUIDE.md          # Windows-specific guide
│
└── docs/                     # Additional documentation
    ├── QUICK-ANSWERS.txt
    ├── FIXES-APPLIED.md
    ├── FIX-QR-ISSUE.md
    ├── QR-CODE-AND-AUTO-FEATURES.md
    ├── SESSION-FIX.md
    ├── VISUAL-GUIDE.txt
    └── ... (more guides)
```

## 🛠️ Troubleshooting

### Common Issues

#### QR Code Not Showing
**Solution:** Open browser to `http://localhost:3000/qr` - the QR code displays there!

#### Node.js Not Found (Windows)
**Solution:**
1. Install from https://nodejs.org/
2. **RESTART your computer** (important!)
3. Run the installer again

#### Node.js Not Found (Mac/Linux)
**Solution:** The installer will attempt to install it automatically, or:
- Ubuntu/Debian: `sudo apt-get install nodejs npm`
- macOS: `brew install node`

#### Port 3000 Already in Use
**Solution:** Edit `server.js` and change `PORT = 3000` to another port like `3001`

#### WhatsApp Won't Connect
**Solution:** Delete the `.wwebjs_auth` folder and run the installer again for a fresh session

#### Installation Fails
**Solution:**
1. Check internet connection
2. Run as Administrator/sudo
3. Clear cache: `npm cache clean --force`
4. Try alternative: `npm install --legacy-peer-deps`

### Need More Help?

See additional guides:
- `QUICK-START.md` - Detailed setup guide
- `TROUBLESHOOTING.md` - Complete troubleshooting guide
- `WINDOWS-GUIDE.md` - Windows-specific instructions
- `docs/QUICK-ANSWERS.txt` - Quick answers to common questions
- `docs/FIX-QR-ISSUE.md` - QR code issues and solutions

## 🔒 Security Notes

- Server runs on **localhost only** (not accessible remotely by default)
- WhatsApp session stored in `.wwebjs_auth` folder
- **Keep session folder private** - it contains your auth data
- **Never share** your session data with others
- Session is automatically cleaned on each restart for security

## 🎬 What Happens When You Run the Installer

1. ✅ Checks if Node.js is installed
2. ✅ Installs Node.js if missing (Mac/Linux auto-install)
3. ✅ Cleans any old sessions for fresh start
4. ✅ Installs all required npm packages
5. ✅ Creates necessary directories (`uploads`, `.wwebjs_auth`)
6. ✅ Starts the server automatically
7. ✅ Displays QR code (terminal + web browser)
8. ✅ Ready to send messages!

## 📊 Server Status

Check server health:
```bash
curl http://localhost:3000/health
```

Check WhatsApp connection status:
```bash
curl http://localhost:3000/api/status
```

## 🔄 Updating

To update the server:
1. Download the latest version
2. Replace all files
3. Run the installer again (it will reinstall dependencies)

## 📝 Configuration

### Change Server Port

Edit `server.js`:
```javascript
const PORT = 3000; // Change to your desired port
```

### Change Session Location

Edit `server.js`:
```javascript
authStrategy: new LocalAuth({
    dataPath: './.wwebjs_auth', // Change this path
})
```

## 🤝 Support

For issues and questions:
1. Check `TROUBLESHOOTING.md`
2. Review `docs/QUICK-ANSWERS.txt`
3. Run the diagnostic tool: `node diagnose.js`
4. Check server logs in the terminal

## 📄 License

MIT License - Feel free to use and modify

## 🙏 Credits

Built with:
- [whatsapp-web.js](https://github.com/pedroslopez/whatsapp-web.js) - WhatsApp Web API
- [Express](https://expressjs.com/) - Web server
- [qrcode-terminal](https://www.npmjs.com/package/qrcode-terminal) - QR code display

---

**Made with care for easy self-hosted WhatsApp messaging**

Need help? Check the `docs/` folder for detailed guides!
