#!/bin/bash

# Change to script directory
cd "$(dirname "$0")"

# Check if setup was run
if [ ! -d "node_modules" ]; then
    echo "============================================================"
    echo "  First Time Setup Required"
    echo "============================================================"
    echo ""
    echo "This is your first time running the WhatsApp server."
    echo "We need to install dependencies first."
    echo ""
    echo "This is fully automatic and will take 2-5 minutes."
    echo ""
    read -p "Press Y to start automatic setup, or N to exit: " -n 1 -r
    echo ""
    if [[ $REPLY =~ ^[Yy]$ ]]; then
        echo ""
        echo "Starting automatic setup..."
        chmod +x SETUP.sh
        ./SETUP.sh
        if [ $? -ne 0 ]; then
            echo ""
            echo "Setup failed. Please check the errors above."
            exit 1
        fi
    else
        exit 0
    fi
fi

# Make sure run.sh is executable
chmod +x run.sh

# Run the server
./run.sh
