# QR Code Not Showing - Quick Fix

## Problem
The QR code is not loading because there's an existing session saved from a previous connection attempt.

## Quick Solution

### Option 1: Delete Session Folder (Recommended)

1. **Stop the WhatsApp server** (close the window or press CTRL+C)

2. **Delete the session folder**:
   ```bash
   # Windows (in whatsapp-server folder)
   rmdir /s /q .wwebjs_auth

   # Or manually: Delete the ".wwebjs_auth" folder
   ```

3. **Restart the server**:
   ```bash
   INSTALL-AND-RUN.bat
   ```

4. **QR code should now appear** in:
   - Terminal/console window
   - Auto-opened browser window at http://localhost:3000/qr

### Option 2: Use Logout API

If the server is running:

```bash
# Send logout request
curl -X POST http://localhost:3000/api/logout

# Then restart the server
```

## Why This Happens

When you added LocalAuth (session persistence):
- The server saves your WhatsApp session to `.wwebjs_auth` folder
- On restart, it tries to reuse the existing session
- If the session is broken/corrupted, no QR code is generated
- You need to delete the session to force a new QR code

## Checking What's Happening

Look at the server console when it starts:

```
📁 Session status: EXISTS (will try to reuse)
```
↑ This means it found a saved session and won't show QR

```
📁 Session status: NOT FOUND (will show QR)
```
↑ This means it will generate a new QR code

## Prevention

After deleting `.wwebjs_auth` and getting a fresh QR code:
1. Scan the QR code
2. Wait for "✅ CONNECTED!" message
3. The session will be saved properly
4. Next restart will reuse the session (no QR needed)

## Manual Steps (Detailed)

1. Navigate to whatsapp-server folder:
   ```
   cd whatsapp-server
   ```

2. Stop server if running

3. Delete session:
   - Find folder named `.wwebjs_auth`
   - Delete it completely
   - On Windows it might be hidden, enable "Show hidden files"

4. Start server again

5. QR code will appear in:
   - Console (text version)
   - Browser window (scannable image)

## Still Not Working?

If QR still doesn't show:

1. **Check console output**:
   - Look for "🎉 QR CODE RECEIVED!"
   - Look for "✅ QR IMAGE READY!"

2. **Check Chrome window**:
   - A Chrome window should open
   - Shows WhatsApp Web loading

3. **Try accessing manually**:
   - Open browser
   - Go to: http://localhost:3000/qr
   - Should show QR or "Loading QR Code..."

4. **Check for errors**:
   - Look in server console for red error messages
   - Common issues:
     - Port 3000 already in use
     - Chrome/Chromium not found
     - Permission issues with .wwebjs_auth folder

## Server Logs to Watch For

✅ **Good signs**:
```
🔥 STARTING WHATSAPP SERVER...
📁 Session status: NOT FOUND (will show QR)
📱 Creating WhatsApp client with session persistence...
⏳ Initializing client...
🎉 QR CODE RECEIVED!
✅ QR IMAGE READY!
```

❌ **Problem signs**:
```
📁 Session status: EXISTS (will try to reuse)
⏳ Loading: 95% - ...
[No QR code appears]
```
↑ Delete `.wwebjs_auth` and restart

## Test After Fix

After getting QR to show:
1. Scan QR with phone
2. Wait for "✅ CONNECTED!"
3. Try sending a test message
4. Should work without [FAILED] errors
